﻿using System;
using System.IO;
using System.Linq;
using System.Runtime.Serialization;
using System.Text;
using System.Xml;
using System.Xml.Schema;
using Revisal.Entities;

namespace XmlReportCreator
{
    class Program
    {
        private static readonly XmlSchemaSet schemas = GetSchema();
        private static readonly DataContractSerializer dataContractSerializer = new DataContractSerializer(typeof(XmlReport));

        // svcutil -t:code /dataContractOnly *.xsd
        static void Main(string[] args)
        {
            var detaliiPJ = new DetaliiAngajatorPersoanaJuridica
            {
                Nume = "Avionul",
                FormaJuridicaPJ = FormaJuridicaPJ.SocietateComerciala,
                FormaOrganizarePJ = FormaOrganizarePJ.SocietatePeActiuni,
                FormaProprietate = FormaProprietate.Mixta,
                DomeniuActivitate = new DomeniuActivitate { Cod = "123" },
                Cui = "19",
                NivelInfiintare = NivelInfiintare.SediuSocial
            };
            var angajator = new Angajator
            {
                Adresa = "Str. Apelor nr. 4",
                Contact = new Contact { ReprezentantLegal = "Cristian Pop", Email = "qw@qw.com", Fax = "1234", Telefon = "4321" },
                Detalii = detaliiPJ,
                Localitate = new Localitate { CodSiruta = 12 }
            };
            var contract = new Contract
            {
                Salariu = 178000,
                DataInceputContract = DateTime.Parse("10/10/2010"),
                DataSfarsitContract = DateTime.Parse("10/10/2011"),
                TipContract = TipContract.ContractIndividualMunca,
                TipDurata = TipDurata.Determinata,
                TipNorma = TipNorma.TimpPartial,
                ExceptieDataSfarsit = ExceptieDataSfarsit.Art83LitE,
                DataContract = DateTime.Parse("10/10/2010"),
                NumarContract = "1321423",
                Detalii = "-",
                StareCurenta = new ContractStareActiv(),
                Cor = new Cor { Cod = 1, Versiune = 5 },
                TimpMunca = new TimpMunca { Norma = NormaTimpMunca.TimpPartial },
                SporuriSalariu = new[] { new Spor { Tip = new TipSporPredefinit { Nume = "Spor Vechime" }, Valoare = 150 }, 
                                                      new Spor { Tip = new TipSporAngajator { Nume = "Spor Pericol" }, Valoare = 1100 } }
            };
            var salariati = new[] { new Salariat {
                Nume = "John",
                Prenume = "Doe",
                Nationalitate = new Nationalitate { Nume = "Roman"},
                Cnp = "CNP",
                Adresa = "-",
                TipActIdentitate = TipActIdentitate.CarteIdentitate,
                Localitate = new Localitate { CodSiruta = 123 },
                Contracte = new [] { contract }
            }};
            var xmlReport = new XmlReport { Header = new Header { Angajator = angajator }, Salariati = salariati };
            
            SaveToFile("XmlReport.xml", xmlReport);
        }

        private static void SaveToFile(string fileName, XmlReport xmlReport)
        {
            using(var xmlWriter = new XmlTextWriter(fileName, Encoding.UTF8) { Formatting = Formatting.Indented })
            {
                xmlWriter.WriteStartDocument();
                dataContractSerializer.WriteObject(xmlWriter, xmlReport);
            }
            CheckSavedXml(fileName);
        }

        private static void CheckSavedXml(string fileName)
        {
            using(var stream = File.OpenRead(fileName))
            {
                var readerSettings = new XmlReaderSettings { ValidationType = ValidationType.Schema, Schemas = schemas };
                using(var xmlReader = XmlReader.Create(stream, readerSettings))
                {
                    var xmlReport = (XmlReport) dataContractSerializer.ReadObject(xmlReader);
                }
            }
        }

        private static XmlSchemaSet GetSchema()
        {
            var schemas = new XmlSchemaSet();
            var schemaFolder = @"..\..\";
            var files = new [] { "schemas_datacontract_org_2004_07_Revisal_Entities.xsd", "schemas_datacontract_org_2004_07_uNhAddIns_Entities.xsd", "schemas_microsoft_com_2003_10_Serialization_.xsd", "www_w3_org_2001_XMLSchema.xsd" }; 
            foreach(var file in files.Select(f => File.OpenRead(schemaFolder + f)))
            {
                schemas.Add(XmlSchema.Read(file, null));
            }
            return schemas;
        }
    }
}